#ifndef PHISICAL_1_0_SAMPLER_H
#define PHISICAL_1_0_SAMPLER_H
#include <vector>
#include "JointVonMisesCircular.h"


class Sampler {
private:
    template<typename PRNG, typename T>
    static int rouletteWheelSelection(const vector<T> &cdf, PRNG &gen);
    template<typename T>
    static int binarySearch(T value, const vector<T> &probabilities, int startIndex, int endIndex);
    template<typename T>
    static vector<T> sumProbabilityList(const vector<T> &probabilities);
    template<typename PRNG >
    static double sampleVonMisesDistribution(float mean, float kappa, PRNG &gen);
    static long double calculateBackboneDensity(const JointVonMisesCircular &component, const vector<float> &backbonePair, const vector<long double> &);
    static long double getPdfEvaluation(const float &angle, const float &mean, const float &concentration, const long double &reciprocal);
    static long double getNormalizingReciprocal(const float &concentration);
    static vector<int> getNearbyComponents(const vector<JointVonMisesCircular> &components, const vector<float> &backbonePair, const vector<vector<double>> &circularStdVector);
    static vector<vector<double>> getCircularStandardDeviation(const vector<JointVonMisesCircular> &mixture);
    static int checkBoundary(float angle, float mean, float std);

public:
    template<typename PRNG >
    static vector<vector<float>> sampleJointVonMisesMixture(const size_t &nsamples, const vector<JointVonMisesCircular> &mixture,
                                            const size_t &angleCount, PRNG &gen);
    template<typename PRNG>
    static vector<vector<float>> sampleConditionalSideChain(const vector<JointVonMisesCircular> &mixture,
    const size_t &angleCount, const size_t &nsamples, const vector<float> &backbonePair, PRNG &gen);
};


#endif
