#ifndef DIRICHLET_H
#define DIRICHLET_H
#include<iostream>
#include<iomanip>
#include<fstream>
#include<cstdio>
#include<cstdlib>
#include<cstring>
#include<cassert>
#include<cmath>
#include<string>
#include<stdint.h>
#include<map>
#include<vector>
#include<sstream>
#include<time.h>
#include "DirichletClass.h"
using namespace std ;

/* Dirichlet defines a p.d.f over a order-1 standard simplex.
 * Has >= 2 parameters (i.e., order)).
 * */
class DirichletClass_t {
    private:
        int nFreeParams;       // = order 
        vector<double> alphas; // params
        double kappa;          // sum over alphas
        vector<double> mu;     // mean vec: alphas[i]/kappa

    public:
        DirichletClass_t(int, vector<double>);
        vector<double> getAlphas();
        vector<double> getMean();
        vector<double> getMode();
        double getPrDensity(vector<double>);
        double getLogPrDensity(vector<double>);
        void printParams();
};
#endif
