#include "FSAClass.h"

FSAClass_t::FSAClass_t() {
    params.push_back(vector<double>(3,0.0)); // dummy n = 0 params. never use them!
    //read file
    ifstream infile("data/MMLSUM_FSAParams_normalized.txt",ios::in);
    assert(infile);
    char buff[10000];
    while (!infile.eof()) {
        infile.getline(buff,10000);
        if (infile.eof()) break;

        stringstream ss;
        ss << buff;
        int n;
        double prmm, prii, prim;
        ss >> n;
        ss >> prmm;
        ss >> prii;
        ss >> prim;
        assert(prmm < 1.0);
        assert(prii+prim < 1.0);
        vector<double> p;
        p.push_back(prmm);
        p.push_back(prii);
        p.push_back(prim);
        params.push_back(p);
    }
  //  assert(params.size() == 601);
    infile.close();
}

double FSAClass_t::getprMM(int N) {
   // cout << N << " vs " << params.size() << endl; 
    assert(N>0&& N<params.size());
    return params[N][0];
}

double FSAClass_t::getprII(int N) {
    assert(N>0&& N<params.size());
    return params[N][1];
}

double FSAClass_t::getprIM(int N) {
    assert(N>0&& N<params.size());
    return params[N][2];
}

void FSAClass_t::printParams() {
    for (int i = 1; i <= 1000; i++) {
        cout << setw(5) << i << fixed << setw(8) << setprecision(5) << params[i][0];
        cout << fixed << setw(8) << setprecision(5) << params[i][1];
        cout << fixed << setw(8) << setprecision(5) << params[i][2]
            << endl;
    }
}

