#ifndef Submat_H
#define Submat_H
#include<iostream>
#include<iomanip>
#include<fstream>
#include<cstdio>
#include<cstdlib>
#include<cstring>
#include<cassert>
#include<cmath>
#include<string>
#include<stdint.h>
#include<map>
#include<vector>
#include<sstream>
#include<time.h>

#include "DirichletClass.h"
#include "FSAClass.h"
#include "nullModelClass.h"
#include "misc.h"
using namespace std ;

class SubmatClass_t {
    /* created for our DAM series of matrices */
    private:
        string alphabet;
        map<char,int> aa2idx;

        vector<vector<double> >     S; // matrix of eigvectors of Mpow1
        vector<vector<double> >     D; // diagonal matrix of eigvalues of Mpow1
        vector<vector<double> >  invS; // inverse of S of Mpow1

        vector<double> stationarydist; // stationary distribution 
        vector<vector<double> > Mpow1; // base mutability (conditional) matrix
                                       // same as cMat[1] (see below)

       /* Series of conditional MpowN matrices. These are precomputed by
        * the constructor, forall 1<=N<=1000. Each column of cMat[N] matrix 
        * adds up to 1. */
        vector<vector<vector<double> > > cMat;                                                   
       /* Series of joint matrices. These are again precomputed by
        * the constructor along with the above (cMat) series (using 
        * the stationary distribution), forall 1<=N<=1000. 
        * Sum over the entire jMat[N] matrix adds up to 1. */
        vector<vector<vector<double> > > jMat; 

        void generateStationaryDistribution();
        void generateConditionalMatrices();
        void generateJointMatrices();
        void normalizeConditionalMat(vector<vector<double> > &);
        void normalizeJointMat(vector<vector<double> > &);


        vector<vector<double> > readMatrix(string);

        /* Inferred Dirichlet priors on the algn 3 state automaton params
         * associated with N, in the range [1,1000].
         * 3 state automaton is over a SYMMETRIC Match, Insert and Delete states.
         * */
        vector<vector<DirichletClass_t> > dirichletpriors; 
        vector<vector<DirichletClass_t> > readDirichletPriors(string);
        FSAClass_t fsaobj;
    public:
        SubmatClass_t();
        SubmatClass_t(string);
        string getAlphabet();
        void regenerateJointMatricesUsingNullModelEstimates(nullModelClass_t &);
        double condlpr(char,char,int); // gets conditional pr(X|Y) for specified N
        double jointpr(char,char,int); // gets joint pr(X,Y) for specified N
        double getS(int,int);
        double getSinv(int,int);
        double getD(int,int);
        int getIndx(char);
        DirichletClass_t getDirichlet(string state,int);
        void printMatpowN(string,int); // print current state of PAM M^K matrix with stats
        void printStationaryDist();
        double getprMM(int);
        double getprII(int);
        double getprIM(int);
};
#endif
