#include "cmdLineParser.h"

bool doesFileExist(string fname) {

    const char *fn  = fname.c_str();
    ifstream infile(fn,ios::in);
    return infile.good();
}

/* Pretty LAME cmdline parser */
void parseCmdLine( 
  int nargs, 
  char *args[],
  vector<string> &seqfn,
  string &param_runType,
  string &param_input_afasta,
  string &param_output_prefix,
  string &param_alignmentType,
  string &param_matrixType,
  string &param_input_refalgn
) {
    bool continueflag = true ;
    multimap<string,string> myMap;

    string currentSwitch = "--seq";
    param_runType = "default";
    for( int i = 1 ; i <  nargs ; i++ ) {
        if( args[i][0]== '-' ) {
            if( strcmp(args[i],"--ivalue") == 0 ) {
                param_runType = "ivalue";
                currentSwitch = args[i];
            }
            else if( strcmp(args[i],"--expalgndist") == 0 ) {
                param_runType = "expalgndist";
                currentSwitch = args[i];
            }
            else if( 
                strcmp(args[i],"-o") == 0 
                || strcmp(args[i],"--criterion") == 0 
                || strcmp(args[i],"--matrix") == 0 
            ) {
                currentSwitch = args[i];
            }
           else if(strcmp(args[i],"--help") == 0) {
                currentSwitch = args[i];
            }
            else  {
                cerr << "::CmdLineError:: Unsupported option: " 
                    << args[i] << endl ;
                continueflag = false ;
                currentSwitch.assign("-X");
            }
        }
        else{
            myMap.insert( pair<string, string>(currentSwitch,args[i])) ;
        }   
    }

    if(param_runType.compare("default")==0 
            && myMap.count("--seq") != 2) {
        if (currentSwitch.compare("--help")!=0) cerr << "::CmdLineError:: " 
            << "Expecting either two sequences (in fasta format) as separate args\n"
            << "                  to align, or one alignment (fasta format) to"
            << "score. See usage below.\n";
        continueflag = false;
    }

    if(param_runType.compare("ivalue")==0 && myMap.count("--ivalue") != 1) {
        cerr << "::CmdLineError:: "
            << "Option \'--ivalue\' takes an alignment fasta file as an argument\n" ;
        continueflag = false;
    }

    if(myMap.count("-o") > 1) {
        cerr << "::CmdLineError:: "
            << "Option \'-o\' takes one output_afasta_string as an argument\n";
        continueflag = false;
    }
    
    if(myMap.count("--criterion") > 1) {
        cerr << "::CmdLineError:: "
            << "Option \'--criterion\' takes exactly one argument\n";
        continueflag = false;
    }

    if(myMap.count("--matrix") > 1) {
        cerr << "::CmdLineError:: "
            << "Option \'--matrix\' takes exactly one argument\n";
        continueflag = false;
    }

    if(param_runType.compare("expalgndist")==0 && myMap.count("--expalgndist") != 1) {
        cerr << "::CmdLineError:: "
            << "Option \'--expalgndist\' takes exactly one argument\n";
        continueflag = false;
    }



    if(myMap.count("-X") > 0 ) {
        cerr << "::CmdLineError:: The following arguments cannot be processed:\n" ;
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("-X");

        /* Loop through range of maps of key "-X" */
        for (multimap<string, string>::iterator itr = range.first;
                     itr != range.second;
             ++itr) {
                cerr << "                  " << (*itr).second << endl;
        }
        continueflag = false;
    }

    //get seq fasta fnames from arguments
    if(
        (param_runType.compare("default")==0 
         || param_runType.compare("expalgndist")==0)
        && myMap.count("--seq") == 2 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--seq");

        /* Loop through range of maps of key "--seq" */
        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            string fname = (*itr).second; 
            if (!doesFileExist(fname)) {
                cerr << "::CmdLineError:: File '" << fname << "' does not exist\n" ;
                continueflag = false;
            }
            seqfn.push_back(fname);
        }
    }

    //assign fasta fname
    if(myMap.count("--ivalue") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--ivalue");

        /* Loop through range of maps of key "--ivalue" */
        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_input_afasta = (*itr).second;
            if (!doesFileExist(param_input_afasta)) {
                cerr << "::CmdLineError:: File '" << param_input_afasta << "' does not exist\n" ;
                continueflag = false;
            }
        }
    }

    //assign fasta fname
    if(myMap.count("--expdistance") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--expdistance");

        param_alignmentType = "marginal";

        /* Loop through range of maps of key "--expdistance" */
        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_input_afasta = (*itr).second;
            if (!doesFileExist(param_input_afasta)) {
                cerr << "::CmdLineError:: File '" << param_input_afasta << "' does not exist\n" ;
                continueflag = false;
            }
        }
    }

    if(myMap.count("--criterion") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--criterion");

        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_alignmentType = (*itr).second;
            if (
                   param_alignmentType.compare("marginal") !=0 
                && param_alignmentType.compare("marginal-interactive") !=0 
                && param_alignmentType.compare("optimal") !=0
            ) {
                cerr << "::CmdLineError:: Invalid option for --criterion: " << param_alignmentType << "\n" ;
                continueflag = false;
            }
        }
    }

    if(myMap.count("--matrix") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--matrix");

        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_matrixType = (*itr).second;
            if (
                   param_matrixType.compare("MMLSUM") !=0 
                && param_matrixType.compare("PAM") !=0 
                && param_matrixType.compare("BLOSUM") !=0
                && param_matrixType.compare("JO") !=0 
                && param_matrixType.compare("JTT") !=0
                && param_matrixType.compare("LG") !=0
                && param_matrixType.compare("MIQS") !=0 
                && param_matrixType.compare("PFASUM") !=0
                && param_matrixType.compare("VTML") !=0 
                && param_matrixType.compare("WAG") !=0 
            ) {
                cerr << "::CmdLineError:: Invalid option for --matrix: " << param_matrixType << "\n" ;
                continueflag = false;
            }
        }
    }

    //assign fname containing marginal probabilities of prefixes
    if(param_runType.compare("expalgndist")==0 && myMap.count("--expalgndist") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("--expalgndist");

        /* Loop through range of maps of key "--expalgndist" */
        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_input_refalgn = (*itr).second;
            if (!doesFileExist(param_input_refalgn)) {
                cerr << "::CmdLineError:: File '" << param_input_refalgn << "' does not exist\n" ;
                continueflag = false;
            }
        }
    }



    if(continueflag == false || nargs < 2 ) {
        cerr  << "\nThere are 3 ways to drive this version of seqMMLigner\n"
            << "For full details refer README file in the main directory.\n\n";

        cerr  << "(1) Infer alignment(s)/relation between sequences:\n";
        cerr  << "    Usage: " << "seqmmligner <seq1 fasta> <seq2 fasta>\n";
        cerr  << "           " << "           (--criterion <optimal/marginal/marginal-interactive>)\n";
        cerr  << "           " << "           ( -o  <output_prefix_string>) \n";
        cerr << endl;
        cerr  << "(2) Score/evaluate any pre-computed alignment:\n";
        cerr  << "    Usage: " << "seqmmligner --ivalue <alignment fasta>\n";
        cerr << endl;
        cerr  << "(3) Compute Expected inter-alignment distance to any reference alignment\n";
        cerr  << "    Usage: " << "seqmmligner <seq1 fasta> <seq2 fasta>"
              << " --expalgndist <ref align fasta>\n\n";
        exit(1) ;
    }

    if (param_runType.compare("default")==0) assert(seqfn.size() == 2);

    //assign output_prefix_string
    if(myMap.count("-o") == 1 ) {
        pair<multimap<string, string>::iterator, multimap<string, string>::iterator> range;
        range = myMap.equal_range("-o");

        /* Loop through range of maps of key "-s" */
        multimap<string, string>::iterator itr;
        for (itr = range.first; itr != range.second; ++itr) {
            param_output_prefix = (*itr).second;
        }
    }
    else {
        string outPrefixString = "";
        outPrefixString.append(getFilenameFromPath(seqfn[0]));
        outPrefixString += "-vs-";
        outPrefixString.append(getFilenameFromPath(seqfn[1]));
        param_output_prefix = outPrefixString;
    }

}
