#include "threeStateDPAClass.h"
#define HTML_HEADER "<html><head></head><body>"
#define HTML_FOOTER "</body></html>"
#define BEGIN_TABLE "<table border=\"1\">"
#define END_TABLE "</table>"
#define BEGIN_ROW "<tr>"
#define END_ROW "</tr>"
#define BEGIN_CELL "<td>"
#define BEGIN_COLOURED_CELL(c) ("<td style=\"background-color:" c "\">")
#define END_CELL "</td>"

#define MARKOV_TIME_LLIMIT  1
#define MARKOV_TIME_ULIMIT  500

using namespace std;

// these two functions below are scoped only within this file
dpcell_t findMin(const vector<dpcell_t> &arr) {
  size_t min_indx = 0;
  for (size_t i = 1; i < 3; i++) {
    if (arr[min_indx].Ivalue > arr[i].Ivalue) {
      min_indx = i;
    }
  }
  return arr[min_indx];
}

// these two functions below are scoped only within this file
double findNeglogSum(vector<double> vals) {
  sort(vals.begin(),vals.end());
  double term = 0.0;
  int sp = 0;
  while (std::isinf(vals[sp]))  sp++;
  for (int i = sp+1; i < vals.size(); i++) {
      term += exp(vals[sp]-vals[i]);
  }
  return vals[sp] -log1p(term);
}
    

double findMinIvalue(double iM, double iD, double iI, int  &min_indx) {
  double array[3];
  array[0] = iM;
  array[1] = iD;
  array[2] = iI;
  //cout << iM << " " << iD << " " << iI << endl;

  min_indx = 0;
  for (size_t i = 1; i < 3; i++) {
    if (array[min_indx] > array[i]) {
      min_indx = i;
    }
  }
  return array[min_indx];
}

double findMinInArray(vector<double> &array) {
  assert(array.size()>0);
  int min_indx = 0;
  for (size_t i = 1; i < array.size(); i++) {
    if (array[min_indx] > array[i]) {
      min_indx = i;
    }
  }
  return array[min_indx];
}

double findMinAndArgMinInArray(vector<double> &array, int &min_indx) {
  assert(array.size()>0);
  min_indx = 0;
  for (size_t i = 1; i < array.size(); i++) {
    if (array[min_indx] > array[i]) {
      min_indx = i;
    }
  }
  return array[min_indx];
}

/* starting here are member function definitions...*/

dpcell_t::dpcell_t() {
  IA = ISTgA = Ivalue = neglogTotPr = neglogTotPr_cell2sink = numeric_limits <double>::infinity();
  nMatched = lenA =0;
  bt= 9; // accepted values [0-8]
}


threeStateDPAClass_t::threeStateDPAClass_t(
 string &S, 
 string &T,
 nullModelClass_t &nullMdl,
 SubmatClass_t &submat,
 int param_startingSubmat_N,
 string param_alignmentType,
 string param_output_prefix
) {
  this->S = S;
  this->T = T;
  this->nullMdl = nullMdl;
  this->submat = submat;
  inferredSubmat_N = param_startingSubmat_N;
  alignmentType = param_alignmentType;
  outputPrefix = param_output_prefix;
  
  runstat = false;

  double nS = S.length();
  double nT = T.length();
  assert(nS>0);
  assert(nT>0);
  
  init();
  assert(dpmat[0].size() == dpmat[2].size());
  assert(dpmat[1].size() == dpmat[2].size());

  cout << endl << left;
  if(alignmentType.compare("optimal") ==0) {
      cout << left;
      cout << "-------------------"  
          << getTerminalColorString("EVALUATING OPTIMAL ALIGNMENT",45) 
          << "------------------\n";
      EM();
  }
  else if(alignmentType.compare("marginal") == 0
          || alignmentType.compare("marginal-interactive") == 0) {
      cout << "            " <<  endl;
      cout << "------------";
      cout << getTerminalColorString("EVALUATING MARGINAL PROBABILITY LANDSCAPE", 45) << "------------\n";
      searchTotalProbOfST();
  }
  //else (!"Something wrong with alignmentType");
  runstat = true;
      cout << "-----------------------------------------------------------------\n\n";
}

//this interface to compute ivalue given an fsastring
threeStateDPAClass_t::threeStateDPAClass_t(
 string &S, 
 string &T,
 string &fsastr,
 nullModelClass_t &nullMdl,
 SubmatClass_t &submat
) {
  this->S = S;
  this->T = T;
  this->nullMdl = nullMdl;
  this->submat = submat;
  
  runstat = false;

  double nS = S.length();
  double nT = T.length();
  assert(nS>0);
  assert(nT>0);


  estimateSubmatParam(fsastr);
  initParams();
  paramStatementMsglen = 0;
  //estimateSubmatParam(fsastr);
  estimateParams(fsastr);
  printParams(inferredSubmat_N);
  cout << "^^^^ " << inferredSubmat_N << endl; 
  algnModelMsgLen = fsa2IA(fsastr) + fsa2ISTgA(fsastr);

  this->IA = fsa2IA(fsastr); this->ISTgA = fsa2ISTgA(fsastr); 
  cout << "I(A,<S,T>)   = " << setw(9) << setprecision(3) << fixed 
      << nits2bits(algnModelMsgLen) <<  " bits" << endl;
  runstat = true;
}



void threeStateDPAClass_t::initParams() {
   assert(fsaPr.size() == 0);
   
   double prMM = submat.getprMM(inferredSubmat_N);
   double prMI = 0.5*(1.0-prMM);
   double prMD = 0.5*(1.0-prMM);
   fsaPr.insert(pair<string,double>("MM",prMM));
   fsaPr.insert(pair<string,double>("MI",prMI));
   fsaPr.insert(pair<string,double>("MD",prMD));

   //double prII = Imode[0];
   double prII = submat.getprII(inferredSubmat_N);
   double prDD = prII;
   //double prIM = Imode[1];
   double prIM = submat.getprIM(inferredSubmat_N);
   double prDM = prIM;
   double prID = 1.0-prII-prIM;
   double prDI = prID;

   fsaPr.insert(pair<string,double>("IM",prIM));
   fsaPr.insert(pair<string,double>("II",prII));
   fsaPr.insert(pair<string,double>("ID",prID));

   fsaPr.insert(pair<string,double>("DM",prDM));
   fsaPr.insert(pair<string,double>("DI",prDI));
   fsaPr.insert(pair<string,double>("DD",prDD));
}

//initialize history matrices;
void threeStateDPAClass_t::init() {
  int nS = S.size();
  int nT = T.size();

  vector<vector<dpcell_t> > tmp;
  for (size_t r = 0 ; r < nS+1; r++) {
    tmp.push_back(vector<dpcell_t>(nT+1));
  }
  dpmat.push_back(tmp); //[0] best alignments ending in   match    state
  dpmat.push_back(tmp); //[1] best alignments ending in   insert   state
  dpmat.push_back(tmp); //[2] best alignments ending in   delete   state
  if (alignmentType.compare("marginal-interactive")==0) {
      dpmat_cell2sink.push_back(tmp);
      dpmat_cell2sink.push_back(tmp);
      dpmat_cell2sink.push_back(tmp);
  }

  initParams();
  paramStatementMsglen = 0;
}

void threeStateDPAClass_t::resetDPMatrices() {
    size_t nS = S.length();
    size_t nT = T.length();
    for (size_t i =  0; i < 3; i++) {
      for (size_t r = 0 ; r < nS+1; r++) {
        for (size_t c = 0 ; c < nT+1; c++) {
          dpmat[i][r][c].IA 
              = dpmat[i][r][c].ISTgA = dpmat[i][r][c].Ivalue 
              = numeric_limits<double>::infinity();
          dpmat[i][r][c].nMatched = dpmat[i][r][c].lenA = 0.0 ;
          dpmat[i][r][c].bt = 9 ;
        }
      }
    }
}

void threeStateDPAClass_t::printParams(int N) {
  cout << "Inferred params ";
  if (alignmentType.compare("optimal") ==0) {
      cout << "(biased estimates for a single best alignment):\n";
  }
  else {
      cout << "(unbaised estimates over all alignments):\n";
  }

  cout << "SeqDist n = " <<setw(3) << N << endl;
  map<string,double>::iterator it;
  cout << fixed;
  for (it=fsaPr.begin(); it!=fsaPr.end(); it++) {
    cout << "Pr(" << it->first << ") = " 
         << setw(6) << setprecision(3) << it->second << endl;
  }
  cout << "\n";
}

void threeStateDPAClass_t::fillDPMatrices() {
 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

 size_t order = nullMdl.getOrder();
 size_t alphabetSize = nullMdl.getAlphabetSize();

 //source cell initialization
 dpmat[0][0][0].IA = dpmat[1][0][0].IA = dpmat[2][0][0].IA = 0.0;
 dpmat[0][0][0].ISTgA  = dpmat[2][0][0].ISTgA  = dpmat[1][0][0].ISTgA  = 0.0 ;
 dpmat[0][0][0].Ivalue = dpmat[1][0][0].Ivalue = dpmat[2][0][0].Ivalue = 0.0 ;


 /* Boundary cases dpmat[0] -- Match    state */
 // r=0 row of dpmat[0] is taboo. These have already been init to be taboo (infinity).
 // c=0 col of dpmat[0] is taboo. == Ditto ==
 // Nothing to do for the boundary case. 
 
 /* Boundary cases for dpmat[1] -- Delete (of S_i)    state  */
 // r=0 row of dpmat[1] is taboo. These have already been init to be taboo (infinity).
 // c=0 col of dpmat[1] needs filling.
 for (size_t r = 1; r < nRows; r++) {
   double Si_nullmodelcost;
   if (r <= order) Si_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Si_nullmodelcost = -log(nullMdl.pr(S.substr(r-1-order,order+1)));

   dpmat[1][r][0].IA =  dpmat[1][r-1][0].IA;  
                       // + -log(fsaPr["DD"])
                       // - wtCodeLen_nits(r-1) // remove prv len term
                       // + wtCodeLen_nits(r); // add new len term
   if (r == 1) dpmat[1][r][0].IA += log(3);
   else dpmat[1][r][0].IA += -log(fsaPr["DD"]);
   dpmat[1][r][0].ISTgA  = dpmat[1][r-1][0].ISTgA + Si_nullmodelcost;
   dpmat[1][r][0].Ivalue = dpmat[1][r][0].IA + dpmat[1][r][0].ISTgA;
   dpmat[1][r][0].bt     = 1; // bt==1 switch to D
   dpmat[1][r][0].lenA   = dpmat[1][r-1][0].lenA+1;
   //cout << dpmat[1][r][0].Ivalue << " " << dpmat[1][r][0].lenA << endl;
 }
 
 /* Boundary cases for dpmat[2] -- Insert (of T_j)    state  */
 // c=0 col of dpmat[2] is taboo. These have already been init to be taboo (infinity).
 // r=0 row of dpmat[2] needs filling
 for (size_t c = 1; c < nCols; c++) {
   double Tj_nullmodelcost;
   if (c <= order) Tj_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c-1-order,order+1)));

   dpmat[2][0][c].IA  = dpmat[2][0][c-1].IA ;
                        //+ -log(fsaPr["II"])
                        //- wtCodeLen_nits(c-1) // remove prv len term
                        //+ wtCodeLen_nits(c) ; // add new len term
   if (c == 1) dpmat[2][0][c].IA += log(3);
   else dpmat[2][0][c].IA += -log(fsaPr["II"]);
   dpmat[2][0][c].ISTgA  = dpmat[2][0][c-1].ISTgA + Tj_nullmodelcost; 
   dpmat[2][0][c].Ivalue = dpmat[2][0][c].IA + dpmat[2][0][c].ISTgA;
   dpmat[2][0][c].bt     = 2 ; // bt==2 switch to I
   dpmat[2][0][c].lenA   = dpmat[2][0][c-1].lenA+1;
 }

 /* Filling out the rest */
 for (size_t r = 1; r < nRows; r++) {
   double Si_nullmodelcost;
   if (r <= order) Si_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Si_nullmodelcost = -log(nullMdl.pr(S.substr(r-1-order,order+1)));

   for (size_t c = 1; c < nCols; c++) {
      double Tj_nullmodelcost;
      if (c <= order) Tj_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
      else            Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c-1-order,order+1)));
      double matchPr = 0.0;
      matchPr = submat.jointpr(S[r-1],T[c-1],inferredSubmat_N);
      double SiTj_matchmodelcost = -log(matchPr);

      /* RECURRENCES GOING INTO M STATE */
      vector<dpcell_t> arrM(3);
      /* FROM M TO M STATE */
      arrM[0].IA = dpmat[0][r-1][c-1].IA ;
                   //+ -log(fsaPr["MM"])
                   //- wtCodeLen_nits(dpmat[0][r-1][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[0][r-1][c-1].lenA+1);
      if (c==1 && r==1) arrM[0].IA += log(3);
      else arrM[0].IA += -log(fsaPr["MM"]);
      arrM[0].ISTgA    = dpmat[0][r-1][c-1].ISTgA + SiTj_matchmodelcost; 
      arrM[0].Ivalue   = arrM[0].IA + arrM[0].ISTgA;
      arrM[0].bt       = 0 ; // bt==0 switch to M
      arrM[0].lenA     = dpmat[0][r-1][c-1].lenA+1;
      arrM[0].nMatched = dpmat[0][r-1][c-1].nMatched+1;
      /* FROM D TO M STATE */
      arrM[1].IA = dpmat[1][r-1][c-1].IA ;
                   //+ -log(fsaPr["DM"])
                   //- wtCodeLen_nits(dpmat[1][r-1][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[1][r-1][c-1].lenA+1);
      if (c==1 && r==1) arrM[1].IA += log(3);
      else arrM[1].IA += -log(fsaPr["DM"]);
      arrM[1].ISTgA    = dpmat[1][r-1][c-1].ISTgA + SiTj_matchmodelcost;
      arrM[1].Ivalue   = arrM[1].IA + arrM[1].ISTgA;
      arrM[1].bt       = 1 ; // bt==1 switch to D
      arrM[1].lenA     = dpmat[1][r-1][c-1].lenA+1;
      arrM[1].nMatched = dpmat[1][r-1][c-1].nMatched+1;
      /* FROM I TO M STATE */
      arrM[2].IA = dpmat[2][r-1][c-1].IA ;
                   //+ -log(fsaPr["IM"])
                   //- wtCodeLen_nits(dpmat[2][r-1][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[2][r-1][c-1].lenA+1);
      if (c==1 && r==1) arrM[2].IA += log(3);
      else arrM[2].IA += -log(fsaPr["IM"]);
      arrM[2].ISTgA    = dpmat[2][r-1][c-1].ISTgA + SiTj_matchmodelcost;
      arrM[2].Ivalue   = arrM[2].IA + arrM[2].ISTgA;
      arrM[2].bt       = 2 ; // bt==2 switch to I
      arrM[2].lenA     = dpmat[2][r-1][c-1].lenA+1;
      arrM[2].nMatched = dpmat[2][r-1][c-1].nMatched+1;
      // Find min of arrM[0].Ivalue, arrM[1].Ivalue, arrM[2].Ivalue
      dpmat[0][r][c]   = findMin(arrM);


      /* RECURRENCES GOING INTO D STATE */
      vector<dpcell_t> arrD(3);
      /* FROM M TO D STATE */
      arrD[0].IA = dpmat[0][r-1][c].IA 
                   + -log(fsaPr["MD"]);
                   //- wtCodeLen_nits(dpmat[0][r-1][c].lenA)
                   //+ wtCodeLen_nits(dpmat[0][r-1][c].lenA+1);
      arrD[0].ISTgA    = dpmat[0][r-1][c].ISTgA + Si_nullmodelcost;
      arrD[0].Ivalue   = arrD[0].IA + arrD[0].ISTgA;
      arrD[0].bt       = 0 ; // bt==0 switch to M
      arrD[0].lenA     = dpmat[0][r-1][c].lenA+1;
      arrD[0].nMatched = dpmat[0][r-1][c].nMatched;
      /* FROM D TO D STATE */
      arrD[1].IA = dpmat[1][r-1][c].IA
                   + -log(fsaPr["DD"]);
                   //- wtCodeLen_nits(dpmat[1][r-1][c].lenA)
                   //+ wtCodeLen_nits(dpmat[1][r-1][c].lenA+1);
      arrD[1].ISTgA    = dpmat[1][r-1][c].ISTgA + Si_nullmodelcost;
      arrD[1].Ivalue   = arrD[1].IA + arrD[1].ISTgA;
      arrD[1].bt       = 1 ; // bt==1 switch to D
      arrD[1].lenA     = dpmat[1][r-1][c].lenA+1;
      arrD[1].nMatched = dpmat[1][r-1][c].nMatched;
      /* FROM I TO D STATE */
      arrD[2].IA = dpmat[2][r-1][c].IA
                   + -log(fsaPr["ID"]);
                   //- wtCodeLen_nits(dpmat[2][r-1][c].lenA)
                   //+ wtCodeLen_nits(dpmat[2][r-1][c].lenA+1);
      arrD[2].ISTgA    = dpmat[2][r-1][c].ISTgA + Si_nullmodelcost;
      arrD[2].Ivalue   = arrD[2].IA + arrD[2].ISTgA;
      arrD[2].bt       = 2; // bt==2 switch to I
      arrD[2].lenA     = dpmat[2][r-1][c].lenA+1;
      arrD[2].nMatched = dpmat[2][r-1][c].nMatched;
      // Find min of arrD[0].Ivalue, arrD[1].Ivalue, arrD[2].Ivalue
      dpmat[1][r][c]   = findMin(arrD);


      /* RECURRENCES GOING INTO I STATE */
      vector<dpcell_t> arrI(3);
      /* FROM M TO I STATE */
      arrI[0].IA = dpmat[0][r][c-1].IA
                   + -log(fsaPr["MI"]);
                   //- wtCodeLen_nits(dpmat[0][r][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[0][r][c-1].lenA+1);
      arrI[0].ISTgA    = dpmat[0][r][c-1].ISTgA + Tj_nullmodelcost;
      arrI[0].Ivalue   = arrI[0].IA + arrI[0].ISTgA;
      arrI[0].bt = 0 ; // bt==0 switch to M
      arrI[0].lenA     = dpmat[0][r][c-1].lenA+1;
      arrI[0].nMatched = dpmat[0][r][c-1].nMatched;
      /* FROM D TO I STATE */
      arrI[1].IA = dpmat[1][r][c-1].IA
                   + -log(fsaPr["DI"]);
                   //- wtCodeLen_nits(dpmat[1][r][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[1][r][c-1].lenA+1);
      arrI[1].ISTgA    = dpmat[1][r][c-1].ISTgA + Tj_nullmodelcost; 
      arrI[1].Ivalue   = arrI[1].IA + arrI[1].ISTgA;
      arrI[1].bt       = 1 ; // bt==1 switch to I
      arrI[1].lenA     = dpmat[1][r][c-1].lenA+1;
      arrI[1].nMatched = dpmat[1][r][c-1].nMatched;
      /* FROM I TO I STATE */
      arrI[2].IA = dpmat[2][r][c-1].IA
                   + -log(fsaPr["II"]);
                   //- wtCodeLen_nits(dpmat[2][r][c-1].lenA)
                   //+ wtCodeLen_nits(dpmat[2][r][c-1].lenA+1);
      arrI[2].ISTgA    = dpmat[2][r][c-1].ISTgA  + Tj_nullmodelcost;
      arrI[2].Ivalue   = arrI[2].IA + arrI[2].ISTgA;
      arrI[2].bt       = 2 ; // bt==2 switch to D
      arrI[2].lenA     = dpmat[2][r][c-1].lenA+1;
      arrI[2].nMatched = dpmat[2][r][c-1].nMatched;
      // Find min of arrI[0].Ivalue, arrI[1].Ivalue, arrI[2].Ivalue
      dpmat[2][r][c]   = findMin(arrI);
    }
 }

 vector<dpcell_t> arr(3);
 arr[0] = dpmat[0][nRows-1][nCols-1]; 
 arr[1] = dpmat[1][nRows-1][nCols-1]; 
 arr[2] = dpmat[2][nRows-1][nCols-1]; 

 dpcell_t tmp = findMin(arr);
 algnModelMsgLen = tmp.Ivalue+paramStatementMsglen+wtCodeLen_nits(tmp.lenA);
}

double threeStateDPAClass_t::traceback(string &algn_fsa,int i, int j, int state) {
  bool fullRun; 
  double IAST;
  if (i == -1 || j == -1 || state ==-1) {  
    i = S.length();
    j = T.length();
    int indx =0;
    IAST = findMinIvalue(dpmat[0][i][j].Ivalue,
                                dpmat[1][i][j].Ivalue,
                                dpmat[2][i][j].Ivalue,
                                indx);
     state = (int)indx;
     fullRun = true;
  }
  else {
      assert(i>=0 && i <= S.length());
      assert(j>=0 && j <= T.length());
      assert(state>=0 && state <=3);
      IAST = dpmat[state][i][j].Ivalue;
      fullRun = false;
  }
  algn_fsa = "";  
  while (i!=0 || j!=0) {
    switch(state) {
      case 0: algn_fsa.push_back('m');
              state = dpmat[0][i][j].bt;
              i--; j--;
              break;
      case 1: algn_fsa.push_back('d');
              state = dpmat[1][i][j].bt;
              i--; j;
              break;
      case 2: algn_fsa.push_back('i');
              state = dpmat[2][i][j].bt;
              i; j--;
              break;
      default:
              cout << "Wierd!\n";
              cout << algn_fsa << endl;
              cout << i << " " << j << " in State " << state << endl;
              exit(0);
              break;
    }
  }
  std::reverse(algn_fsa.begin(),algn_fsa.end());
  if (fullRun) {
     optAlgnFSAStr = algn_fsa;
  }
  if (fullRun) IAST += wtCodeLen_nits(algn_fsa.length()) + paramStatementMsglen;
  return IAST;
}

void threeStateDPAClass_t::fillDPMatrices_cell2sink() {
 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

 size_t order = nullMdl.getOrder();
 size_t alphabetSize = nullMdl.getAlphabetSize();

 //sink cell initialization.
 int r_sink = nRows-1;
 int c_sink = nCols-1;
 dpmat_cell2sink[0][r_sink][c_sink].IA 
     = dpmat_cell2sink[1][r_sink][c_sink].IA 
     = dpmat_cell2sink[2][r_sink][c_sink].IA = 0.0;
 dpmat_cell2sink[0][r_sink][c_sink].ISTgA 
     = dpmat_cell2sink[2][r_sink][c_sink].ISTgA 
     = dpmat_cell2sink[1][r_sink][c_sink].ISTgA = 0.0;
 dpmat_cell2sink[0][r_sink][c_sink].Ivalue
     = dpmat_cell2sink[1][r_sink][c_sink].Ivalue 
     = dpmat_cell2sink[2][r_sink][c_sink].Ivalue = 0.0 ;


 for (ssize_t r = r_sink-1; r >= 0; r--) {
   double Si_nullmodelcost = -log(nullMdl.pr(S.substr(r,1)));

   dpmat_cell2sink[1][r][c_sink].IA =  dpmat_cell2sink[1][r+1][c_sink].IA;  
   if (r == r_sink-1) dpmat_cell2sink[1][r][c_sink].IA += log(3);
   else dpmat_cell2sink[1][r][c_sink].IA += -log(fsaPr["DD"]);
   dpmat_cell2sink[1][r][c_sink].ISTgA  = dpmat_cell2sink[1][r+1][c_sink].ISTgA + Si_nullmodelcost;
   dpmat_cell2sink[1][r][c_sink].Ivalue 
       = dpmat_cell2sink[1][r][c_sink].IA + dpmat_cell2sink[1][r][c_sink].ISTgA;
   dpmat_cell2sink[1][r][c_sink].bt     = 1; // bt==1 switch to D
   dpmat_cell2sink[1][r][c_sink].lenA   = dpmat_cell2sink[1][r+1][c_sink].lenA+1;
 }
 
 for (ssize_t c = c_sink-1; c >= 0; c--) {
   double Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c,1)));

   dpmat_cell2sink[2][r_sink][c].IA  = dpmat_cell2sink[2][r_sink][c+1].IA ;
   if (c == c_sink-1) dpmat_cell2sink[2][r_sink][c].IA += log(3);
   else dpmat_cell2sink[2][r_sink][c].IA += -log(fsaPr["II"]);
   dpmat_cell2sink[2][r_sink][c].ISTgA  = dpmat_cell2sink[2][r_sink][c+1].ISTgA + Tj_nullmodelcost; 
   dpmat_cell2sink[2][r_sink][c].Ivalue 
       = dpmat_cell2sink[2][r_sink][c].IA + dpmat_cell2sink[2][r_sink][c].ISTgA;
   dpmat_cell2sink[2][r_sink][c].bt     = 2 ; // bt==2 switch to I
   dpmat_cell2sink[2][r_sink][c].lenA   = dpmat_cell2sink[2][r_sink][c+1].lenA+1;
 }

 /* Filling out the rest */
 for (ssize_t r = r_sink-1; r >= 0; r--) {
   double Si_nullmodelcost = -log(nullMdl.pr(S.substr(r,1)));

 for (ssize_t c = c_sink-1; c >= 0; c--) {
   double Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c,1)));

      double matchPr = 0.0;
      matchPr = submat.jointpr(S[r],T[c],inferredSubmat_N);
      double SiTj_matchmodelcost = -log(matchPr);

      /* RECURRENCES GOING INTO M STATE */
      vector<dpcell_t> arrM(3);
      /* FROM M TO M STATE */
      arrM[0].IA = dpmat_cell2sink[0][r+1][c+1].IA ;
      if (c==c_sink-1 && r==r_sink-1) arrM[0].IA += log(3);
      else arrM[0].IA += -log(fsaPr["MM"]);
      arrM[0].ISTgA    = dpmat_cell2sink[0][r+1][c+1].ISTgA + SiTj_matchmodelcost; 
      arrM[0].Ivalue   = arrM[0].IA + arrM[0].ISTgA;
      arrM[0].bt       = 0 ; // bt==0 switch to M
      arrM[0].lenA     = dpmat_cell2sink[0][r+1][c+1].lenA+1;
      arrM[0].nMatched = dpmat_cell2sink[0][r+1][c+1].nMatched+1;
      /* FROM D TO M STATE */
      arrM[1].IA = dpmat_cell2sink[1][r+1][c+1].IA ;
      if (c==c_sink-1 && r==r_sink-1) arrM[1].IA += log(3);
      else arrM[1].IA += -log(fsaPr["MD"]);
      arrM[1].ISTgA    = dpmat_cell2sink[1][r+1][c+1].ISTgA + SiTj_matchmodelcost;
      arrM[1].Ivalue   = arrM[1].IA + arrM[1].ISTgA;
      arrM[1].bt       = 1 ; // bt==1 switch to D
      arrM[1].lenA     = dpmat_cell2sink[1][r+1][c+1].lenA+1;
      arrM[1].nMatched = dpmat_cell2sink[1][r+1][c+1].nMatched+1;
      /* FROM I TO M STATE */
      arrM[2].IA = dpmat_cell2sink[2][r+1][c+1].IA ;
      if (c==c_sink-1 && r==r_sink-1) arrM[2].IA += log(3);
      else arrM[2].IA += -log(fsaPr["MI"]);
      arrM[2].ISTgA    = dpmat_cell2sink[2][r+1][c+1].ISTgA + SiTj_matchmodelcost;
      arrM[2].Ivalue   = arrM[2].IA + arrM[2].ISTgA;
      arrM[2].bt       = 2 ; // bt==2 switch to I
      arrM[2].lenA     = dpmat_cell2sink[2][r+1][c+1].lenA+1;
      arrM[2].nMatched = dpmat_cell2sink[2][r+1][c+1].nMatched+1;
      // Find min of arrM[0].Ivalue, arrM[1].Ivalue, arrM[2].Ivalue
      dpmat_cell2sink[0][r][c]   = findMin(arrM);


      /* RECURRENCES GOING INTO D STATE */
      vector<dpcell_t> arrD(3);
      /* FROM M TO D STATE */
      arrD[0].IA = dpmat_cell2sink[0][r+1][c].IA 
                   + -log(fsaPr["DM"]);
      arrD[0].ISTgA    = dpmat_cell2sink[0][r+1][c].ISTgA + Si_nullmodelcost;
      arrD[0].Ivalue   = arrD[0].IA + arrD[0].ISTgA;
      arrD[0].bt       = 0 ; // bt==0 switch to M
      arrD[0].lenA     = dpmat_cell2sink[0][r+1][c].lenA+1;
      arrD[0].nMatched = dpmat_cell2sink[0][r+1][c].nMatched;
      /* FROM D TO D STATE */
      arrD[1].IA = dpmat_cell2sink[1][r+1][c].IA
                   + -log(fsaPr["DD"]);
      arrD[1].ISTgA    = dpmat_cell2sink[1][r+1][c].ISTgA + Si_nullmodelcost;
      arrD[1].Ivalue   = arrD[1].IA + arrD[1].ISTgA;
      arrD[1].bt       = 1 ; // bt==1 switch to D
      arrD[1].lenA     = dpmat_cell2sink[1][r+1][c].lenA+1;
      arrD[1].nMatched = dpmat_cell2sink[1][r+1][c].nMatched;
      /* FROM I TO D STATE */
      arrD[2].IA = dpmat_cell2sink[2][r+1][c].IA
                   + -log(fsaPr["DI"]);
      arrD[2].ISTgA    = dpmat_cell2sink[2][r+1][c].ISTgA + Si_nullmodelcost;
      arrD[2].Ivalue   = arrD[2].IA + arrD[2].ISTgA;
      arrD[2].bt       = 2; // bt==2 switch to I
      arrD[2].lenA     = dpmat_cell2sink[2][r+1][c].lenA+1;
      arrD[2].nMatched = dpmat_cell2sink[2][r+1][c].nMatched;
      // Find min of arrD[0].Ivalue, arrD[1].Ivalue, arrD[2].Ivalue
      dpmat_cell2sink[1][r][c]   = findMin(arrD);


      /* RECURRENCES GOING INTO I STATE */
      vector<dpcell_t> arrI(3);
      /* FROM M TO I STATE */
      arrI[0].IA = dpmat_cell2sink[0][r][c+1].IA
                   + -log(fsaPr["IM"]);
      arrI[0].ISTgA    = dpmat_cell2sink[0][r][c+1].ISTgA + Tj_nullmodelcost;
      arrI[0].Ivalue   = arrI[0].IA + arrI[0].ISTgA;
      arrI[0].bt = 0 ; // bt==0 switch to M
      arrI[0].lenA     = dpmat_cell2sink[0][r][c+1].lenA+1;
      arrI[0].nMatched = dpmat_cell2sink[0][r][c+1].nMatched;
      /* FROM D TO I STATE */
      arrI[1].IA = dpmat_cell2sink[1][r][c+1].IA
                   + -log(fsaPr["ID"]);
      arrI[1].ISTgA    = dpmat_cell2sink[1][r][c+1].ISTgA + Tj_nullmodelcost; 
      arrI[1].Ivalue   = arrI[1].IA + arrI[1].ISTgA;
      arrI[1].bt       = 1 ; // bt==1 switch to I
      arrI[1].lenA     = dpmat_cell2sink[1][r][c+1].lenA+1;
      arrI[1].nMatched = dpmat_cell2sink[1][r][c+1].nMatched;
      /* FROM I TO I STATE */
      arrI[2].IA = dpmat_cell2sink[2][r][c+1].IA
                   + -log(fsaPr["II"]);
      arrI[2].ISTgA    = dpmat_cell2sink[2][r][c+1].ISTgA  + Tj_nullmodelcost;
      arrI[2].Ivalue   = arrI[2].IA + arrI[2].ISTgA;
      arrI[2].bt       = 2 ; // bt==2 switch to D
      arrI[2].lenA     = dpmat_cell2sink[2][r][c+1].lenA+1;
      arrI[2].nMatched = dpmat_cell2sink[2][r][c+1].nMatched;
      // Find min of arrI[0].Ivalue, arrI[1].Ivalue, arrI[2].Ivalue
      dpmat_cell2sink[2][r][c]   = findMin(arrI);
    }
 }

 vector<dpcell_t> arr(3);
 arr[0] = dpmat_cell2sink[0][0][0]; 
 arr[1] = dpmat_cell2sink[1][0][0]; 
 arr[2] = dpmat_cell2sink[2][0][0]; 

 dpcell_t tmp = findMin(arr);
 algnModelMsgLen_rev = tmp.Ivalue+paramStatementMsglen+wtCodeLen_nits(tmp.lenA);
}

double threeStateDPAClass_t::traceforward(string &algn_fsa,int i, int j, int state) {
  bool fullRun; 
  double IAST;
  if (i == -1 || j == -1 || state ==-1) {  
    i = 0;
    j = 0;
    int indx;
    IAST = findMinIvalue(dpmat_cell2sink[0][i][j].Ivalue,
                         dpmat_cell2sink[1][i][j].Ivalue,
                         dpmat_cell2sink[2][i][j].Ivalue,
                         indx);
    state = (int)indx;
    fullRun = true;
  }
  else {
      assert(i>=0 && i <= S.length());
      assert(j>=0 && j <= T.length());
      assert(state>=0 && state <=3);
      IAST = dpmat_cell2sink[state][i][j].Ivalue;
      fullRun = false;
  }

  algn_fsa = ""; 
  while (i!=S.length() || j!=T.length()) {
    switch(state) {
      case 0: algn_fsa.push_back('m');
              state = dpmat_cell2sink[0][i][j].bt;
              i++; j++;
              break;
      case 1: algn_fsa.push_back('d');
              state = dpmat_cell2sink[1][i][j].bt;
              i++; j;
              break;
      case 2: algn_fsa.push_back('i');
              state = dpmat_cell2sink[2][i][j].bt;
              i; j++;
              break;
      default:
              cout << "Wierd!\n";
              cout << algn_fsa << endl;
              cout << i << " " << j << " in State " << state << endl;
              exit(0);
              break;
    }
  }
  if (fullRun) {
      optAlgnFSAStr_rev = algn_fsa;
  }
  if (fullRun) IAST += wtCodeLen_nits(algn_fsa.length()) + paramStatementMsglen;
  return IAST;
}

// computes Total Pr of <S,T> by summing over all alignments.
double threeStateDPAClass_t::computeTotalProbOfST(int N, bool printFlag=false) {
 estimate3StateMachineParams_dirichlet(N);

 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

 size_t order = nullMdl.getOrder();
 size_t alphabetSize = nullMdl.getAlphabetSize();

 //source cell initialization.
// dpmat[0][0][0].IA = dpmat[1][0][0].IA = dpmat[2][0][0].IA = 0.0;
// dpmat[0][0][0].ISTgA  = dpmat[2][0][0].ISTgA  = dpmat[1][0][0].ISTgA  = 0.0 ;
// dpmat[0][0][0].Ivalue = dpmat[1][0][0].Ivalue = dpmat[2][0][0].Ivalue = 0.0 ;
 dpmat[0][0][0].neglogTotPr = 0.0;
// = dpmat[1][0][0].neglogTotPr
// = dpmat[2][0][0].neglogTotPr = 0.0;


 /* Boundary cases dpmat[0] -- Match    state */
 // r=0 row of dpmat[0] is taboo. Pr = 0 => neglogTotPr= infty; this is already set by init
 // c=0 col of dpmat[0] is taboo. == Ditto ==
 // Nothing to do for the boundary case. 
 
 /* Boundary cases for dpmat[1] -- Delete (of S_i)    state  */
 // r=0 row of dpmat[1] is taboo. These have already been init to be taboo (infinity).
 // c=0 col of dpmat[1] needs filling.
 for (size_t r = 1; r < nRows; r++) {
   double Si_nullmodelcost;
   if (r <= order) Si_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Si_nullmodelcost = -log(nullMdl.pr(S.substr(r-1-order,order+1)));
   if (r == 1)  {
      dpmat[1][r][0].neglogTotPr = Si_nullmodelcost;
      dpmat[1][r][0].neglogTotPr += log(3);
   }
   else {
      dpmat[1][r][0].neglogTotPr  = dpmat[1][r-1][0].neglogTotPr;
      dpmat[1][r][0].neglogTotPr += Si_nullmodelcost;
      dpmat[1][r][0].neglogTotPr += -log(fsaPr["DD"]);
   }
 }
 
 /* Boundary cases for dpmat[2] -- Insert (of T_j)    state  */
 // c=0 col of dpmat[2] is taboo. These have already been init to be taboo (infinity).
 // r=0 row of dpmat[2] needs filling
 for (size_t c = 1; c < nCols; c++) {
   double Tj_nullmodelcost;
   if (c <= order) Tj_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c-1-order,order+1)));

   if (c == 1) {
      dpmat[2][0][c].neglogTotPr = Tj_nullmodelcost;
      dpmat[2][0][c].neglogTotPr += log(3);
   }
   else{ 
      dpmat[2][0][c].neglogTotPr  = dpmat[2][0][c-1].neglogTotPr;
      dpmat[2][0][c].neglogTotPr += Tj_nullmodelcost;
      dpmat[2][0][c].neglogTotPr += -log(fsaPr["II"]);
   }
 }

 /* Filling out the rest */
 for (size_t r = 1; r < nRows; r++) {
   double Si_nullmodelcost;
   if (r <= order) Si_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Si_nullmodelcost = -log(nullMdl.pr(S.substr(r-1-order,order+1)));

   for (size_t c = 1; c < nCols; c++) {
      double Tj_nullmodelcost;
      if (c <= order) Tj_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
      else            Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c-1-order,order+1)));
      double matchPr = 0.0;
      matchPr = submat.jointpr(S[r-1],T[c-1],N);
      double SiTj_matchmodelcost = -log(matchPr);

      /* RECURRENCES GOING INTO M STATE */
      vector<double> arrM(3);
      /* FROM M TO M STATE */
      arrM[0] = dpmat[0][r-1][c-1].neglogTotPr;
      if (c==1 && r==1) arrM[0] += log(3);
      else arrM[0] += -log(fsaPr["MM"]);
      arrM[0]      += SiTj_matchmodelcost; 
      /* FROM D TO M STATE */
      arrM[1] = dpmat[1][r-1][c-1].neglogTotPr;
      if (c==1 && r==1) arrM[1] += log(3);
      else arrM[1] += -log(fsaPr["DM"]);
      arrM[1] +=  SiTj_matchmodelcost;
      /* FROM I TO M STATE */
      arrM[2] = dpmat[2][r-1][c-1].neglogTotPr;
      if (c==1 && r==1) arrM[2] += log(3);
      else arrM[2] += -log(fsaPr["IM"]);
      arrM[2] += SiTj_matchmodelcost;
      // Find logsum of arrM[0/1/2].neglogTotPr
      dpmat[0][r][c].neglogTotPr  = findNeglogSum(arrM);
  

      /* RECURRENCES GOING INTO D STATE */
      vector<double> arrD(3);
      /* FROM M TO D STATE */
      arrD[0]  = dpmat[0][r-1][c].neglogTotPr;
      arrD[0] += -log(fsaPr["MD"]);
      arrD[0] += Si_nullmodelcost;
      /* FROM D TO D STATE */
      arrD[1]  = dpmat[1][r-1][c].neglogTotPr;
      arrD[1] += -log(fsaPr["DD"]);
      arrD[1] += Si_nullmodelcost;
      /* FROM I TO D STATE */
      arrD[2]  = dpmat[2][r-1][c].neglogTotPr;
      arrD[2] += -log(fsaPr["ID"]);
      arrD[2] += Si_nullmodelcost;
      // Find min of arrD[0].Ivalue, arrD[1].Ivalue, arrD[2].Ivalue
      dpmat[1][r][c].neglogTotPr   = findNeglogSum(arrD);
     

      /* RECURRENCES GOING INTO I STATE */
      vector<double> arrI(3);
      /* FROM M TO I STATE */
      arrI[0]  = dpmat[0][r][c-1].neglogTotPr;
      arrI[0] += -log(fsaPr["MI"]);
      arrI[0] += Tj_nullmodelcost;
      /* FROM D TO I STATE */
      arrI[1]  = dpmat[1][r][c-1].neglogTotPr;
      arrI[1] += -log(fsaPr["DI"]);
      arrI[1] += Tj_nullmodelcost; 
      /* FROM I TO I STATE */
      arrI[2]  = dpmat[2][r][c-1].neglogTotPr;
      arrI[2] += -log(fsaPr["II"]);
      arrI[2] += Tj_nullmodelcost;
      // Find min of arrI[0].Ivalue, arrI[1].Ivalue, arrI[2].Ivalue
      dpmat[2][r][c].neglogTotPr = findNeglogSum(arrI);
     
    }
 }

 vector<double> arr(3);
 arr[0] = dpmat[0][nRows-1][nCols-1].neglogTotPr; 
 arr[1] = dpmat[1][nRows-1][nCols-1].neglogTotPr; 
 arr[2] = dpmat[2][nRows-1][nCols-1].neglogTotPr; 

 marginalModelMsgLen = findNeglogSum(arr);
 marginalModelMsgLen += log(MARKOV_TIME_ULIMIT - MARKOV_TIME_LLIMIT + 1);

 marginalModelMsgLen += wtCodeLen_nits(S.length()>T.length()?S.length():T.length());
 //marginalModelMsgLen += wtCodeLen_nits(S.length()+T.length());

 if (printFlag) {
     cout << "......................................" << endl;
     printParams(N);
     cout << "Information measure:\n";
     cout << "-log("
         << getTerminalColorString("marginal probability",46) 
         << ") = I_marginal(<S,T>) = ";
     stringstream ss;
     ss << fixed  << setprecision(3)
         << nits2bits(marginalModelMsgLen);
     cout << getTerminalColorString(ss.str(),43) << " bits."<< endl;
 }

 return marginalModelMsgLen;
}


// computes Total Pr by summing over all alignments ending at SINK rather than SOURCE
double threeStateDPAClass_t::computeTotalProbOfST_2sink(bool printFlag=false) {
 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

 size_t order = nullMdl.getOrder();
 size_t alphabetSize = nullMdl.getAlphabetSize();

 //sink cell initialization.
 int r_sink = nRows-1;
 int c_sink = nCols-1;
 dpmat[0][r_sink][c_sink].neglogTotPr_cell2sink = 0.0;

 for (ssize_t r = r_sink-1; r >= 0; r--) {
   double Si_nullmodelcost = -log(nullMdl.pr(S.substr(r,1)));

   if (r == r_sink-1) {
      dpmat[1][r][c_sink].neglogTotPr_cell2sink = Si_nullmodelcost;
      dpmat[1][r][c_sink].neglogTotPr_cell2sink += log(3);
   }
   else{

      dpmat[1][r][c_sink].neglogTotPr_cell2sink  = dpmat[1][r+1][c_sink].neglogTotPr_cell2sink;
      dpmat[1][r][c_sink].neglogTotPr_cell2sink += Si_nullmodelcost;
      dpmat[1][r][c_sink].neglogTotPr_cell2sink += -log(fsaPr["DD"]);
   }
 }
 
 /* Boundary cases for dpmat[2] -- Insert (of T_j)    state  */
 // c=c_sink col of dpmat[2] is taboo. These have already been init to be taboo (infinity).
 // r=r_sink row of dpmat[2] needs filling
 for (ssize_t c = c_sink-1; c >= 0; c--) {
   double Tj_nullmodelcost;
   /*
   if (c <= order) Tj_nullmodelcost = -log((double)1/nullMdl.getAlphabetSize()); 
   else            Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c-order,order+1)));
   */
   Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c,1)));

   if (c == c_sink-1) {
      dpmat[2][r_sink][c].neglogTotPr_cell2sink = Tj_nullmodelcost;
      dpmat[2][r_sink][c].neglogTotPr_cell2sink += log(3);
   }
   else {
      dpmat[2][r_sink][c].neglogTotPr_cell2sink  = dpmat[2][r_sink][c+1].neglogTotPr_cell2sink;
      dpmat[2][r_sink][c].neglogTotPr_cell2sink += Tj_nullmodelcost;
      dpmat[2][r_sink][c].neglogTotPr_cell2sink += -log(fsaPr["II"]);
   }
 }

 /* Filling out the rest */
 for (ssize_t r = r_sink-1; r >=0; r--) {
   double Si_nullmodelcost;
   Si_nullmodelcost = -log(nullMdl.pr(S.substr(r,1)));

   for (ssize_t c = c_sink-1; c >= 0; c--) {
      double Tj_nullmodelcost;
      Tj_nullmodelcost = -log(nullMdl.pr(T.substr(c,1)));

      double matchPr = 0.0;
      matchPr = submat.jointpr(S[r],T[c],inferredSubmat_N);
      double SiTj_matchmodelcost = -log(matchPr);

      /* RECURRENCES GOING INTO M STATE */
      vector<double> arrM(3);
      /* FROM M TO M STATE */
      arrM[0] = dpmat[0][r+1][c+1].neglogTotPr_cell2sink;
      if (c==c_sink-1 && r==r_sink-1) arrM[0] += log(3);
      else arrM[0] += -log(fsaPr["MM"]);
      arrM[0]      += SiTj_matchmodelcost; 
      /* FROM D TO M STATE */
      arrM[1] = dpmat[1][r+1][c+1].neglogTotPr_cell2sink;
      if (c==c_sink-1 && r==r_sink-1) arrM[1] += log(3);
      else arrM[1] += -log(fsaPr["MD"]); // using MD instead of DM as we are running from sink to cell rather than source to cell
      arrM[1] +=  SiTj_matchmodelcost;
      /* FROM I TO M STATE */
      arrM[2] = dpmat[2][r+1][c+1].neglogTotPr_cell2sink;
      if (c==c_sink-1 && r==r_sink-1) arrM[2] += log(3);
      else arrM[2] += -log(fsaPr["MI"]);
      arrM[2] += SiTj_matchmodelcost;
      // Find logsum of arrM[0/1/2].neglogTotPr_cell2sink
      dpmat[0][r][c].neglogTotPr_cell2sink  = findNeglogSum(arrM);



      /* RECURRENCES GOING INTO D STATE */
      vector<double> arrD(3);
      /* FROM M TO D STATE */
      arrD[0]  = dpmat[0][r+1][c].neglogTotPr_cell2sink;
      arrD[0] += -log(fsaPr["DM"]);
      arrD[0] += Si_nullmodelcost;
      /* FROM D TO D STATE */
      arrD[1]  = dpmat[1][r+1][c].neglogTotPr_cell2sink;
      arrD[1] += -log(fsaPr["DD"]);
      arrD[1] += Si_nullmodelcost;
      /* FROM I TO D STATE */
      arrD[2]  = dpmat[2][r+1][c].neglogTotPr_cell2sink;
      arrD[2] += -log(fsaPr["DI"]);
      arrD[2] += Si_nullmodelcost;
      // Find min of arrD[0].Ivalue, arrD[1].Ivalue, arrD[2].Ivalue
      dpmat[1][r][c].neglogTotPr_cell2sink   = findNeglogSum(arrD);



      /* RECURRENCES GOING INTO I STATE */
      vector<double> arrI(3);
      /* FROM M TO I STATE */
      arrI[0]  = dpmat[0][r][c+1].neglogTotPr_cell2sink;
      arrI[0] += -log(fsaPr["IM"]);
      arrI[0] += Tj_nullmodelcost;
      /* FROM D TO I STATE */
      arrI[1]  = dpmat[1][r][c+1].neglogTotPr_cell2sink;
      arrI[1] += -log(fsaPr["ID"]);
      arrI[1] += Tj_nullmodelcost; 
      /* FROM I TO I STATE */
      arrI[2]  = dpmat[2][r][c+1].neglogTotPr_cell2sink;
      arrI[2] += -log(fsaPr["II"]);
      arrI[2] += Tj_nullmodelcost;
      // Find min of arrI[0].Ivalue, arrI[1].Ivalue, arrI[2].Ivalue
      dpmat[2][r][c].neglogTotPr_cell2sink = findNeglogSum(arrI);
    }
 }


 vector<double> arr(3);
 arr[0] = dpmat[0][0][0].neglogTotPr_cell2sink; 
 arr[1] = dpmat[1][0][0].neglogTotPr_cell2sink; 
 arr[2] = dpmat[2][0][0].neglogTotPr_cell2sink; 

 marginalModelMsgLen_rev = findNeglogSum(arr);
 marginalModelMsgLen_rev += log(MARKOV_TIME_ULIMIT - MARKOV_TIME_LLIMIT + 1);

 marginalModelMsgLen_rev += wtCodeLen_nits(S.length()>T.length()?S.length():T.length());
// marginalModelMsgLen_rev += wtCodeLen_nits(S.length()+T.length());

 return marginalModelMsgLen;
}



void threeStateDPAClass_t::estimateParams(string fsastr) {
  paramStatementMsglen = log(MARKOV_TIME_ULIMIT - MARKOV_TIME_LLIMIT + 1);  

  if (fsastr.length() > 0) {
      estimateSubmatParam(fsastr);
      estimate3StateMachineParams_dirichlet(inferredSubmat_N);
  }
}

double threeStateDPAClass_t::evalNegLogMatches(vector<string> A, int n) {
    double val = 0;
    for (int l = 0; l < A.size(); l++) {
        double term = 0;
        for (int k = 0; k < 20; k++) {
            int i = submat.getIndx(A[l][0]);
            int j = submat.getIndx(A[l][1]);
            double     lmda = submat.getD(k,k);
            double    S_ik  = submat.getS(i,k);
            double invS_kj  = submat.getSinv(k,j);
            term += pow(lmda,n)*S_ik*invS_kj; 
        }
        val += -log(term);
    }
    return val;
}

double threeStateDPAClass_t::evalNegLogMatches_fullAlignment(string fsastr, vector<string> A, int n) {
  assert(fsastr.length() == A.size());
  assert(n>0);
  assert(n<=1000);

  //DirichletClass_t MstateDirichlet = submat.getDirichlet("match",n);
  //DirichletClass_t IstateDirichlet = submat.getDirichlet("insert",n);
  //vector<double> Mmode = MstateDirichlet.getMode();
  //vector<double> Imode = IstateDirichlet.getMode();
  //double prMM = Mmode[0];
  double prMM = submat.getprMM(n);
  double prMI = 0.5*(1.0-prMM);
  double prMD = 0.5*(1.0-prMM);

  //double prII = Imode[0];
  double prII = submat.getprII(n);
  double prDD = prII;
  //double prIM = Imode[1];
  double prIM = submat.getprIM(n);
  double prDM = prIM;
  double prID = 1.0-prII-prIM;
  double prDI = prID;

  double msglen = log(MARKOV_TIME_ULIMIT - MARKOV_TIME_LLIMIT + 1);
  msglen += wtCodeLen_nits(fsastr.length());
  //first aligned pair
  char prev_state = '*';
  for (int l = 0; l < A.size(); l++) {
    char curr_state = fsastr[l];  
    if (curr_state == 'm') {
        assert(A[l][0]!='-'&&A[l][1]!='-');
        char S_i = A[l][0];
        char T_j = A[l][1];
        double matchPr = submat.jointpr(S_i,T_j,n);
        msglen += -log(matchPr);
    }
    else if (curr_state == 'd') {
        assert(A[l][0]!='-'&&A[l][1]=='-');
        char S_i = A[l][0];
        double nullPr_S_i = nullMdl.pr(string(1,S_i));
        msglen += -log(nullPr_S_i);
    }
    else if (curr_state == 'i') {
        assert(A[l][0]=='-'&&A[l][1]!='-');
        char T_j = A[l][1];
        double nullPr_T_j = nullMdl.pr(string(1,T_j));
        msglen += -log(nullPr_T_j);
    }
    else {
        assert(!"Non m/i/d state found in fsastr");
    }

    if (prev_state == '*') msglen += -log(1.0/3.0);
    else {
             if (prev_state == 'm' && curr_state == 'm') msglen += -log(prMM);
        else if (prev_state == 'm' && curr_state == 'd') msglen += -log(prMD);
        else if (prev_state == 'm' && curr_state == 'i') msglen += -log(prMI);
        else if (prev_state == 'd' && curr_state == 'm') msglen += -log(prDM);
        else if (prev_state == 'd' && curr_state == 'd') msglen += -log(prDD);
        else if (prev_state == 'd' && curr_state == 'i') msglen += -log(prDI);
        else if (prev_state == 'i' && curr_state == 'm') msglen += -log(prIM);
        else if (prev_state == 'i' && curr_state == 'd') msglen += -log(prID);
        else if (prev_state == 'i' && curr_state == 'i') msglen += -log(prII);
    }
    prev_state = curr_state;
  }
  return msglen;
}


void threeStateDPAClass_t::estimateSubmatParam(string fsastr) {
  if (fsastr.length() == 0) return;

  //cout << "Estimating submat param for fsastr:\n" << fsastr << endl;
  vector<string> Amatches; // note, vector of 2-tuples representing match cols.
  vector<string> A;        // full alignment cols.
  int iS = 0, jT = 0;
  for (size_t l = 0; l < fsastr.length(); l++) {
      //cout << fsastr[l] << " ";
      if (fsastr[l] == 'd') {
          string mpair = "";
          mpair += S[iS];
          mpair += '-';
          assert(mpair.length() == 2);
          A.push_back(mpair);
          iS++;
      }
      else if (fsastr[l] == 'i') {
          string mpair = "";
          mpair += '-';
          mpair += T[jT];
          assert(mpair.length() == 2);
          A.push_back(mpair);
          jT++;
      }
      else if (fsastr[l] == 'm') {
          string mpair = "";
          mpair += S[iS];
          mpair += T[jT];
          assert(mpair.length() == 2);
          A.push_back(mpair);
          Amatches.push_back(mpair); // separately, only matches
          iS++;
          jT++;
      }
      else {
          cout << fsastr[l] << " " << "Something wierd!" << endl;
          assert(1);
      }
      //if (fsastr[l] == 'm') cout << A[A.size()-1] << endl;
      //else cout << endl;
  }

  double min = numeric_limits <double>::infinity();
  int min_k = MARKOV_TIME_LLIMIT;
  // use bisection-like search to find min_k
  int lo = MARKOV_TIME_LLIMIT;
  int hi = MARKOV_TIME_ULIMIT; 

  while (lo < hi) {
      int lo_quartile = (int)round(lo + (double)(hi-lo)/4.0);
      int hi_quartile = (int)round(hi - (double)(hi-lo)/4.0);
      double f1 = evalNegLogMatches_fullAlignment(fsastr,A, lo_quartile);
      double f2 = evalNegLogMatches_fullAlignment(fsastr,A, hi_quartile);

      if (hi_quartile-lo_quartile <=1) {
        for (int K = lo; K <= hi; K++) {
           double msglen;
           if (K==lo_quartile)  msglen = f1;
           else if (K==hi_quartile)  msglen = f2;
           else msglen = evalNegLogMatches_fullAlignment(fsastr,A,K);
           if (msglen < min) {
              min = msglen;
              min_k = K;
           }
        }
        break;
      }
      else{
          if (f1 < f2) {
              hi = hi_quartile;
              if (f1 < min) {
                  min_k = lo_quartile;
                  min = f1;
              }
          }
          else {
              lo = lo_quartile;
              if (f2 < min) {
                  min_k = hi_quartile;
                  min = f2;
              }
          }
      }
  }
  inferredSubmat_N = min_k;
}


void threeStateDPAClass_t::estimate3StateMachineParams_dirichlet( int N) {
  double prMM = submat.getprMM(N);
  double prMI = 0.5*(1.0-prMM);
  double prMD = 0.5*(1.0-prMM);
  fsaPr["MM"] = prMM;
  fsaPr["MI"] = prMI;
  fsaPr["MD"] = prMD;

  //double prII = Imode[0];
  double prII = submat.getprII(N);
  double prDD = prII;
  //double prIM = Imode[1];
  double prIM = submat.getprIM(N);
  double prDM = prIM;
  double prID = 1.0-prII-prIM;
  double prDI = prID;

  fsaPr["IM"] = prIM;
  fsaPr["II"] = prII;
  fsaPr["ID"] = prID;

  fsaPr["DM"] = prDM;
  fsaPr["DI"] = prDI;
  fsaPr["DD"] = prDD;

  assert(fsaPr["MM"]+fsaPr["MI"]+fsaPr["MD"] > 0.999999999999999);
  assert(fsaPr["IM"]+fsaPr["II"]+fsaPr["ID"] > 0.999999999999999);
  assert(fsaPr["DM"]+fsaPr["DI"]+fsaPr["DD"] > 0.999999999999999);

  /* //Read comment below
  paramStatementMsglen += 0; //mode params already in the codebook
  */

}


void threeStateDPAClass_t::EM() {
  size_t max_iters = 10;
  string prev_fsastr = ""; //currently empty
  string curr_fsastr = ""; //currently empty
  double IAST;
  double tmp;
  size_t iter = 1 ;
  do {
    estimateParams(curr_fsastr);
    fillDPMatrices();
    prev_fsastr = curr_fsastr;
    curr_fsastr = "";
    IAST = traceback(curr_fsastr);
    resetDPMatrices();
  } while (prev_fsastr.compare(curr_fsastr) && iter++ <= max_iters);
  printParams(inferredSubmat_N);
  cout << "Information measure:\n";
  cout << "I(" << getTerminalColorString("best-A",46) 
      << ",<S,T>)  = ";
  stringstream ss;
  ss << fixed << setprecision(3) << nits2bits(IAST);
  cout << getTerminalColorString(ss.str(),43) << " bits " << endl;
  printFSAstr2Algn(getOptAlignFSAstr(),S,T);

}

void threeStateDPAClass_t::searchTotalProbOfST() {
  cout << "Searching for -log(marginal prob.) of sequences\n" << flush;
  int min_k = MARKOV_TIME_LLIMIT;
  //bisection-like search to find min_k
  int lo = MARKOV_TIME_LLIMIT;
  int hi = MARKOV_TIME_ULIMIT; 
  double min_algnModelMsgLen = numeric_limits <double>::infinity();
  while (lo < hi) {
      int lo_quartile = (int)round(lo + (double)(hi-lo)/4.0);
      int hi_quartile = (int)round(hi - (double)(hi-lo)/4.0);
      double f1 = computeTotalProbOfST(lo_quartile);
      double f2 = computeTotalProbOfST(hi_quartile);
      if (hi_quartile-lo_quartile <=1) {
        for (int K = lo; K <= hi; K++) {
           double msglen;
           if (K==lo_quartile)  msglen = f1;
           else if (K==hi_quartile)  msglen = f2;
           else msglen = computeTotalProbOfST(K);

           if (msglen < min_algnModelMsgLen) {
              min_algnModelMsgLen = msglen;
              min_k = K;
           }
        }
        break;
      }
      else {
      if (f1 < f2) {
          hi = hi_quartile;
          if (f1 < min_algnModelMsgLen) {
              min_k = lo_quartile;
              min_algnModelMsgLen = f1;
          }
      }
      else {
          lo = lo_quartile;
          if (f2 < min_algnModelMsgLen) {
              min_k = hi_quartile;
              min_algnModelMsgLen = f2;
          }
      }
      }
  }
  inferredSubmat_N = min_k;
  marginalModelMsgLen = computeTotalProbOfST(inferredSubmat_N,true);
     cout << "......................................    [OK]" << endl;

 ///*
  cout << "Computing marginal probability landscape: " << flush;
  computeTotalProbOfST_2sink(false);
  printTotalFwdPlusBwd();
  cout << "[OK]\n";
  cout << "Landscape csv file written to:             " << getTerminalColorString(outputPrefix+"_MarginalProbabilityLandscape.csv",43) << "\n";
  cout << "Landscape Matlab/octave script written to: " << getTerminalColorString(outputPrefix + "_MarginalProbabilityLandscape.m",43) << "\n";

  //*/
  int cntr = 1;
  if (alignmentType.compare("marginal-interactive")==0) {
      cout << "\n.....Entering interactive mode........     " << endl;
      cout << "(This mode allows you to specify a" << getTerminalColorString("cell (i,j)",41) << "and it prints\n" 
           << " out the best alignment passing through the cell within the\n"
           << " marginal probability landscape)\n";
      estimateParams((string)"");
      fillDPMatrices();
      fillDPMatrices_cell2sink();
      int r,c;
      bool pickStatus = false;
      while (pickStatus == false) {
          bool cellFlag = false;
          cout << "\n\nPick any cell" << getTerminalColorString("(i,j)",41) << "in the landscape:\n";
          while(cellFlag == false) {
            cout << "    Enter index i followed by space followed by j: ";
            cin >> r >> c;
            cin.clear();
            cin.ignore(std::numeric_limits<std::streamsize>::max(),'\n');
            if (r>=0 && r<= S.length() && c>=0 && c<= T.length()) cellFlag = true;
            else {
                cout << "Wrong index(es): index-i should be between 0 and " 
                    << S.length() << " (inclusive)\n";
                cout << "Wrong index(es): index-j should be between 0 and " 
                    << T.length() << " (inclusive)\n";
                cout << "Try again\n";
            }
          }
          cout << "        Cell (" << r << "," << c << ") has been selected\n\n";
          string algnfsastr =  printAlignmentThroughCell(r,c);
          vector<string> algn = fsastr2Algn(algnfsastr,S,T);
          printFSAstr2Algn(algnfsastr,S,T);
           
          cout << "\n\n";
          cout << "What next? (choose one of the following options)\n";
          int option = 1;
          bool optionStatus = false;
          while (optionStatus == false) {
              cout << "  [1] continue and pick another cell\n";
              cout << "  [2] save alignment and exit\n";
              cout << "  [3] save alignment and continue\n";
              cout << "  [4] exit interactive mode\n";
              cout << "Enter option [ ]\b\b";
              cin >> option;
              cin.clear();
              cin.ignore(std::numeric_limits<std::streamsize>::max(),'\n');
              if (option <1 || option >4) cout << endl;
              else optionStatus= true;
          } 
          if (option == 1) continue;
          else if (option ==2 || option ==3) {
                time_t rawtime;
                struct tm * timeinfo;
                char buffer[80];
                time (&rawtime);
                timeinfo = localtime (&rawtime);
                strftime (buffer,80,"_%F_%H%M%S",timeinfo);
              stringstream ss;
              ss << outputPrefix << buffer <<".afasta";
              string outfn = ss.str();
              ofstream algnout(outfn.c_str(), ios::out);
              assert(algnout);


              algnout << ">aligned seq 1" << endl;
              for (size_t i = 0; i < algnfsastr.length(); i++) {
                  algnout << algn[0][i];
                  if ((i+1)%60 == 0 || (i+1) == algnfsastr.length()) algnout << endl;
              }
              algnout << endl;

              algnout << ">aligned seq 2" << endl;
              for (size_t i = 0; i < algnfsastr.length(); i++) {
                  algnout << algn[1][i];
                  if ((i+1)%60 == 0 || (i+1) == algnfsastr.length()) algnout << endl;
              }
              cout << "Alignment fasta (afasta) file written to:  " << outfn << endl;
              if (option == 2)pickStatus = true;
          }
          else {
              pickStatus = true;
          }
      }
  }

}

string threeStateDPAClass_t::printAlignmentThroughCell(int r, int c) {
 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

 double fwd[nRows][nCols];
 double bwd[nRows][nCols];
 double fwdplusbwd[nRows][nCols];

 double val = 0.0;
 vector<double> arr_fwd(3);
 arr_fwd[0] = dpmat[0][r][c].Ivalue; 
 arr_fwd[1] = dpmat[1][r][c].Ivalue; 
 arr_fwd[2] = dpmat[2][r][c].Ivalue; 
 int min_indx_fwd;
 fwd[r][c] = findMinAndArgMinInArray(arr_fwd,min_indx_fwd);

 vector<double> arr_bwd(3);
 arr_bwd[0] = dpmat_cell2sink[0][r][c].Ivalue; 
 arr_bwd[1] = dpmat_cell2sink[1][r][c].Ivalue; 
 arr_bwd[2] = dpmat_cell2sink[2][r][c].Ivalue; 
 int min_indx_bwd;
 bwd[r][c] = findMinAndArgMinInArray(arr_bwd,min_indx_bwd);

 double IAST;
 string finalized_algn_fsa;
 if ((r == 0 && c == 0)) {
     IAST = traceforward(finalized_algn_fsa);
 }
 else if (r == nRows-1 && c==nCols-1) {
     IAST = traceback(finalized_algn_fsa);
 }
 else{
     vector<double> parts;
     vector<string> fsas;
     string fsa_fwd;
     string fsa_bwd;
     string fsa_fwd_plus_bwd;
     double IAST_fwd, IAST_bwd;
     //stitch fwd and bwd totals.
     //fwd ending in M, bwd ending in M
     val  = arr_fwd[0];
     val += -log(fsaPr["MM"]);
     val += arr_bwd[0];
     if (r==0||c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,0);
     if (r==nRows-1||c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,0);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in D, bwd ending in M
     val  = arr_fwd[1];
     val += -log(fsaPr["DM"]);
     val += arr_bwd[0];
     if (r==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,1);
     if (r==nRows-1||c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else  IAST_bwd  = traceforward(fsa_bwd,r,c,0);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in I, bwd ending in M
     val  = arr_fwd[2];
     val += -log(fsaPr["IM"]);
     val += arr_bwd[0];
     if (c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,2);
     if (r==nRows-1||c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,0);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in M, bwd ending in D
     val  = arr_fwd[0];
     val += -log(fsaPr["MD"]);
     val += arr_bwd[1];
     if (r==0||c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,0);
     if (r==nRows-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,1);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in D, bwd ending in D
     val  = arr_fwd[1];
     val += -log(fsaPr["DD"]);
     val += arr_bwd[1];
     if (r==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,1);
     if (r==nRows-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,1);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in I, bwd ending in D
     val  = arr_fwd[2];
     val += -log(fsaPr["ID"]);
     val += arr_bwd[1];
     if (c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,2);
     if (r==nRows-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,1);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);


     //fwd ending in M, bwd ending in I
     val  = arr_fwd[0];
     val += -log(fsaPr["MI"]);
     val += arr_bwd[2];
     if (r==0||c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,0);
     if (c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,2);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in D, bwd ending in I
     val  = arr_fwd[1];
     val += -log(fsaPr["DI"]);
     val += arr_bwd[2];
     if (r==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,1);
     if (c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,2);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     //fwd ending in I, bwd ending in I
     val  = arr_fwd[2];
     val += -log(fsaPr["II"]);
     val += arr_bwd[2];
     if (c==0) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_fwd  = traceback(fsa_fwd,r,c,2);
     if (c==nCols-1) IAST_fwd = numeric_limits <double>::infinity();
     else IAST_bwd  = traceforward(fsa_bwd,r,c,2);
     fsa_fwd_plus_bwd  = fsa_fwd + fsa_bwd;
     val += wtCodeLen_nits(fsa_fwd_plus_bwd.length()) + paramStatementMsglen -log(3);
     fsas.push_back(fsa_fwd_plus_bwd);
     parts.push_back(val);

     assert(fsas.size() == 9);
     int min_indx;
     IAST = findMinAndArgMinInArray(parts,min_indx);
     assert(min_indx >=0 && min_indx <=8);
     finalized_algn_fsa = fsas[min_indx];
 }
 cout << "         For the alignment A (printed below) passing through the cell ("
     << r << "," << c <<"):\n";
 cout << "          I(A,<S,T>) = " << nits2bits(IAST) << " bits.\n";
 cout << "         Over all alignments passing through the the cell ("
     << r << "," << c <<"):\n";
 cout << "          -log(marginal) = " << nits2bits(landscape[r][c]) << " bits.\n";
 return finalized_algn_fsa;
}
///*

void threeStateDPAClass_t::printTotalFwdPlusBwd() {
 size_t nRows = S.length()+1;
 size_t nCols = T.length()+1;

  vector<vector<double>> fwd, bwd;
  //alloc space for landscape, fwd, bwd
 
  for (int i = 0; i < nRows; i++) {
    landscape.push_back(vector<double>(nCols,0.0));
    fwd.push_back(vector<double>(nCols,0.0));
    bwd.push_back(vector<double>(nCols,0.0));
  }

  double val = 0.0;
  for (size_t r = 0; r < nRows; r++) {
     for (size_t c = 0; c < nCols; c++) {
         vector<double> arr_fwd(3);
         arr_fwd[0] = dpmat[0][r][c].neglogTotPr; 
         arr_fwd[1] = dpmat[1][r][c].neglogTotPr; 
         arr_fwd[2] = dpmat[2][r][c].neglogTotPr; 
         fwd[r][c] = findNeglogSum(arr_fwd);
         vector<double> arr_bwd(3);
         arr_bwd[0] = dpmat[0][r][c].neglogTotPr_cell2sink; 
         arr_bwd[1] = dpmat[1][r][c].neglogTotPr_cell2sink; 
         arr_bwd[2] = dpmat[2][r][c].neglogTotPr_cell2sink; 
         bwd[r][c] = findNeglogSum(arr_bwd);

         vector<double> parts;
         if ((r == 0 && c == 0)) {
             parts.push_back(arr_bwd[0]);
             parts.push_back(arr_bwd[1]);
             parts.push_back(arr_bwd[2]);
         }
         else if (r == nRows-1 && c==nCols-1) {
             parts.push_back(arr_fwd[0]);
             parts.push_back(arr_fwd[1]);
             parts.push_back(arr_fwd[2]);
         }
         else{

             //stitch fwd and bwd totals.
             //fwd ending in M, bwd ending in M
             val  = arr_fwd[0];
             val += -log(fsaPr["MM"]);
             val += arr_bwd[0];
             parts.push_back(val);
             //fwd ending in D, bwd ending in M
             val  = arr_fwd[1];
             val += -log(fsaPr["DM"]);
             val += arr_bwd[0];
             parts.push_back(val);
             //fwd ending in I, bwd ending in M
             val  = arr_fwd[2];
             val += -log(fsaPr["IM"]);
             val += arr_bwd[0];
             parts.push_back(val);

             //fwd ending in M, bwd ending in D
             val  = arr_fwd[0];
             val += -log(fsaPr["MD"]);
             val += arr_bwd[1];
             parts.push_back(val);
             //fwd ending in D, bwd ending in D
             val  = arr_fwd[1];
             val += -log(fsaPr["DD"]);
             val += arr_bwd[1];
             parts.push_back(val);
             //fwd ending in I, bwd ending in D
             val  = arr_fwd[2];
             val += -log(fsaPr["ID"]);
             val += arr_bwd[1];
             parts.push_back(val);

             //fwd ending in M, bwd ending in I
             val  = arr_fwd[0];
             val += -log(fsaPr["MI"]);
             val += arr_bwd[2];
             parts.push_back(val);
             //fwd ending in D, bwd ending in I
             val  = arr_fwd[1];
             val += -log(fsaPr["DI"]);
             val += arr_bwd[2];
             parts.push_back(val);
             //fwd ending in I, bwd ending in I
             val  = arr_fwd[2];
             val += -log(fsaPr["II"]);
             val += arr_bwd[2];
             parts.push_back(val);
         }
         landscape[r][c]  = findNeglogSum(parts);
         landscape[r][c] += log(MARKOV_TIME_ULIMIT - MARKOV_TIME_LLIMIT + 1);
         landscape[r][c] += wtCodeLen_nits(S.length()>T.length()?S.length():T.length());
         //landscape[r][c] += wtCodeLen_nits(S.length()+T.length());
         if ((r == nRows-1 && c==nCols-1) || r == 0 && c== 0) {
             landscape[r][c] += 0; // do nothing
         }
         else {
            landscape[r][c] -= log(3);
         }
     }
  }

 //write to landscape.txt file
 string outcsvfn = outputPrefix + "_MarginalProbabilityLandscape.csv";
 string outmfn = outputPrefix + "_MarginalProbabilityLandscape.m";
 ofstream out(outcsvfn.c_str(),ios::out);
 assert(out);
 ofstream outm(outmfn.c_str(),ios::out);
 assert(outm);
 outm << "M  = [";
 for (size_t r = 0; r < nRows; r++) {
     for (size_t c = 0; c < nCols; c++) {
         out << fixed << setprecision(2) << nits2bits(landscape[r][c]);
         if (c < nCols-1) out <<","; 
         outm << fixed << setw(8) << setprecision(2) << nits2bits(landscape[r][c]); 
     }
     if (r < nRows-1) outm << ";\n";
     else outm << "];\nimagesc(M);\n";
     out << endl;
 }
 out.close();
 outm.close();

}
//*/

double threeStateDPAClass_t::getOptAlignMsgLen() {
  return algnModelMsgLen;
}

double threeStateDPAClass_t::getMarginalProbMsgLen() {
  return marginalModelMsgLen;
}


string threeStateDPAClass_t::getOptAlignFSAstr() {
  return optAlgnFSAStr;
}

double threeStateDPAClass_t::fsa2IA(string fsastr) { 
  double fsastrStringMsgLen = 0;
  int order = 1;
  int alphabetSize = 3;
  for (size_t i = 0; i < order; i++) {
    fsastrStringMsgLen += -log((double)1.0/alphabetSize); 
  }
  for (size_t i = order; i < fsastr.length(); i++) {
    if (fsastr[i-1] == 'm' && fsastr[i] == 'm') {
      fsastrStringMsgLen += -log(fsaPr["MM"]);
    }
    else if (fsastr[i-1] == 'm' && fsastr[i] == 'd') {
      fsastrStringMsgLen += -log(fsaPr["MD"]);
    }
    else if (fsastr[i-1] == 'm' && fsastr[i] == 'i') {
      fsastrStringMsgLen += -log(fsaPr["MI"]);
    }
    else if (fsastr[i-1] == 'd' && fsastr[i] == 'm') {
      fsastrStringMsgLen += -log(fsaPr["DM"]);
    }
    else if (fsastr[i-1] == 'd' && fsastr[i] == 'd') {
      fsastrStringMsgLen += -log(fsaPr["DD"]);
    }
    else if (fsastr[i-1] == 'd' && fsastr[i] == 'i') {
      fsastrStringMsgLen += -log(fsaPr["DI"]);
    }
    else if (fsastr[i-1] == 'i' && fsastr[i] == 'm') {
      fsastrStringMsgLen += -log(fsaPr["IM"]);
    }
    else if (fsastr[i-1] == 'i' && fsastr[i] == 'd') {
      fsastrStringMsgLen += -log(fsaPr["ID"]);
    }
    else if (fsastr[i-1] == 'i' && fsastr[i] == 'i') {
      fsastrStringMsgLen += -log(fsaPr["II"]);
    }
  }
  double IA =  wtCodeLen_nits(fsastr.length()) + paramStatementMsglen + fsastrStringMsgLen;
  cout << "I(A)         = " << setw(9) << setprecision(3) << fixed << nits2bits(IA) << " bits" << endl;
  return IA;
}

double threeStateDPAClass_t::fsa2ISTgA(string fsastr) { 
  estimateParams(fsastr);
  double msglen = 0;
  int order = nullMdl.getOrder();
  int alphabetSize = nullMdl.getAlphabetSize();
  int iS = 0, jT = 0;
  for (size_t k = 0; k < fsastr.length(); k++) {
      if (fsastr[k] == 'd') {
          if (k < order) msglen += -log((double)1/alphabetSize);
          else msglen += -log(nullMdl.pr(S.substr(iS-order,order+1)));
          iS++;
      }
      else if (fsastr[k] == 'i') {
          if (k < order) msglen += -log((double)1/alphabetSize);
          else msglen += -log(nullMdl.pr(T.substr(jT-order,order+1)));
          jT++;
      }
      else if (fsastr[k] == 'm') {
          char S_i = S[iS];
          char T_j = T[jT];
          double matchPr = submat.jointpr(S_i,T_j,inferredSubmat_N);
          msglen += -log(matchPr);
          iS++;
          jT++;
      }
      else {
          cout << fsastr[k] << " " << "Something wierd!" << endl;
          assert(1);
      }
  }
  double ISTgA =  msglen;
  cout << "I(<S,T>|A)   = " << setw(9) << setprecision(3) << fixed << nits2bits(ISTgA) << " bits" << endl;
  return ISTgA;
}


int threeStateDPAClass_t::getInferredSubmatN() {
    return inferredSubmat_N;
}

vector<vector<vector<dpcell_t> > > threeStateDPAClass_t::getMarginalDPMatrices() {
    return dpmat;
}



