#ifndef DPCLASS_H
#define DPCLASS_H
#include<iostream>
#include<fstream>
#include<cstdio>
#include<cstdlib>
#include<cstring>
#include<cassert>
#include<string>
#include<stdint.h>
#include<limits>
#include<map>
#include<vector>
#include<sstream>
#include<time.h>
#include <algorithm>

#include "misc.h"
#include "SubmatClass.h"
#include "nullModelClass.h"
#include "dpcellClass.h"
using namespace std;

class threeStateDPAClass_t {
  private:
    string S;
    string T;
    nullModelClass_t nullMdl;
    SubmatClass_t    submat;
    int inferredSubmat_N;
    string alignmentType;     
    string outputPrefix;
    map<string,double> fsaPr;
    vector<vector<vector<dpcell_t> > > dpmat;
    vector<vector<vector<dpcell_t> > > dpmat_cell2sink;
    double paramStatementMsglen;
    double algnModelMsgLen;
    double algnModelMsgLen_rev;
    double marginalModelMsgLen;
    double marginalModelMsgLen_rev;
    string optAlgnFSAStr;
    string optAlgnFSAStr_rev;
    vector<vector<double> > landscape; 
    void init();
    void initParams();
    void resetDPMatrices();
    void estimateParams(string);
    double evalNegLogMatches(vector<string>, int); 
    double evalNegLogMatches_fullAlignment(string, vector<string>, int); 
    void estimateSubmatParam(string);
    void estimate3StateMachineParams_dirichlet(int); //est as the mode under the assoc. dirichlet
    bool runstat;
    void printTotalFwdPlusBwd();
    string printAlignmentThroughCell(int,int);

  public:
    threeStateDPAClass_t(string &,string &,nullModelClass_t &,SubmatClass_t &, int, string, string);
    threeStateDPAClass_t(string &,string &, string &, nullModelClass_t &,SubmatClass_t &); // overloaded to compute ivalue 
    void fillDPMatrices();
    void fillDPMatrices_cell2sink();
    double traceback(string&,int =-1,int=-1,int=-1);
    double traceforward(string&,int=-1,int=-1,int=-1);
    void EM();
    double computeTotalProbOfST(int,bool);
    double computeTotalProbOfST_2sink(bool);
    void searchTotalProbOfST();
    void printParams(int);
    double getOptAlignMsgLen();
    double getMarginalProbMsgLen();
    string getOptAlignFSAstr();
    double fsa2IA(string);
    double fsa2ISTgA(string);
    int getInferredSubmatN();
    //added for expalgndist computation
    //which returns the computed neg log marginals
    //across three states.
    vector<vector<vector<dpcell_t> > > getMarginalDPMatrices();

    double IA,ISTgA; // DS

};
#endif
